//////////////////////////////////////////////////////////////////////////////
//  Copyright 2014 by Autodesk, Inc.  All rights reserved.
//
// This computer source code and related instructions and comments 
// are the unpublished confidential and proprietary information of 
// Autodesk, Inc. and are protected under applicable copyright and 
// trade secret law.  They may not be disclosed to, copied or used 
// by any third party without the prior written consent of Autodesk, Inc.
//////////////////////////////////////////////////////////////////////////////

/*globals $,jQuery,document, window, navigator*/

/*!
* ntp.content - Dynamic updates of new tab page content
*/

// Namespace
var ntp = ntp || {};
ntp.content = ntp.content || {};

/**
 * Load string table as json data
 */
ntp.content.applyLocalizedStrings = function(localizedStrings) {
    // Verify string data
    if (localizedStrings !== null) {
        // Load localized strings and initialize text elements
        $('*[data-text-id]').each(function() {
            var $element = $(this);
            $element.html(localizedStrings[$element.data('text-id')]);
        });

        $('*[data-text-map]').each(function() {
            var $element = $(this);
            var textMap = $element.data('text-map');
            $.each(textMap, function(index, value) {
                $element.attr(index, localizedStrings[value]);
            });
        });
    }
};
/**
 * Gets or sets the map from file type to thumbnail image
 */
ntp.content.thumbnail = (function() {
    var thumbnails = {};
    var defaultThumbnail = 'images/default_thumb.png';

    // Gets or sets the settings object.
    return function(param, param1) {
        if ( typeof param === 'string') {
            if ( typeof param1 === 'string') {
                // Setting value
                thumbnails[param] = param1;
            } else {
                // Getting value
                var thumbnail = thumbnails[param];

                if ( typeof thumbnail === 'string') {
                    return thumbnail;
                } else {
                    return defaultThumbnail;
                }
            }

        } else {
            $.error('Invalid paramters.');
        }
    };
})();

ntp.content.tryTab = (function () {
    var isEnabled = false;
    var isTrial = false;
    var productLine;
    var productRelease;
    var productLang;
    var daysLeft = 0;
    var country;
    var basicUrl = null;
    var settingUrl = null;
    var isLoaded = false;
    // Gets or sets the settings object.
    return {
        getLoaded: function () {
            return isLoaded;
        },

        setTrial: function (state) {
            isTrial = state;
        },
        
        getTrial: function () {
            return isTrial;
        },
        
        applySettings: function (settings, spec){
            if(typeof settings.widgets !== 'undefined' && typeof spec !== 'undefined'){
                if(typeof settings.widgets.itm !== 'undefined' && typeof spec.tryTab !== 'undefined' ){
                    if(typeof spec.tryTab.enabled === 'string' && spec.tryTab.enabled.toLowerCase() === 'yes'){
                        if(typeof settings.widgets.itm.BasicURL === 'string')
                            basicUrl = settings.widgets.itm.BasicURL;
                        if(typeof spec.tryTab.settingUrl === 'string')
                            settingUrl = spec.tryTab.settingUrl;

                        //Get product information that will be used by ITM page.
                        if(basicUrl !== null && settingUrl !== null)
                            ntp.acad.getProductInfoAsJSON().done(ntp.utils.makeCallback(this, 'refreshProductInfoWithJSON'));
                    }
                }
            }
        },
        
        //Get product information from native side.
        refreshProductInfoWithJSON: function (productInfo) {
            var data = $.parseJSON(productInfo);
            if (typeof data.retValue !== 'undefined')
                data = data.retValue; // hoist retValue if present 

            if (data.trial === true && data.productLine !== null &&
                    data.productRelease !== null && data.productLang !== null
                    && data.country !== null && data.daysleft >= 0) {
                $('#tab_try .placeholder').addClass('loading');
                //save product information
                isTrial = true;
                productLine = data.productLine;
                productRelease = data.productRelease;
                productLang = data.productLang.toLowerCase();
                country = data.country.toLowerCase();
                daysLeft = data.daysleft;
                //Load try tab setting
                $.ajax({
                    url : settingUrl,
                    dataType : 'jsonp',
                    jsonpCallback : 'tryTabCallback',
                    crossDomain : true,
                    timeout : 5000,
                    success : function(data) {
                        //get setting file from ITM server
                        //try to load ITM page.
                        ntp.content.tryTab.loadITMPage(data);
                    },
                    error : function(xhr, status, error) {
                        // Don't get settings file.
                        $('#tab_try .placeholder').removeClass('loading');
                    }
                });
            }
        },
        
        //Refresh page
        refreshTryTabWithJSON: function (licenseInfo) {
            var data = $.parseJSON(licenseInfo);
            if (typeof data.retValue !== 'undefined')
                data = data.retValue; // hoist retValue if present
            if (data.type !== 2) {
                if (isLoaded === true) {
                    ntp.page.tabs.removeVisibleTab('tab_try', 'tab_create');
                }
            }
            else {
                if (isLoaded === false && basicUrl !== null && settingUrl !== null){
                    ntp.acad.getProductInfoAsJSON().done(ntp.utils.makeCallback(this, 'refreshProductInfoWithJSON'));
                }
            }
        },
        
        loadITMPage: function (data) {
            //load ITM page into try tab.
            if (typeof data !== 'undefined') {
                if (typeof data.retValue !== 'undefined')
                    data = data.retValue; // hoist retValue if present
                if (data.enabled.toLowerCase() == "yes") {
                    if(data.country instanceof Array && data.language instanceof Array){
                        var isSupportCountry = false;
                        var isSupportLang = false;
                        for(var i = 0; i < data.country.length; i++){
                            if(data.country[i].toLowerCase() === country){
                                isSupportCountry = true;
                                for(var k = 0; k < data.language.length; k++){
                                    if(data.language[k].toLowerCase() === productLang){
                                        isSupportLang = true;
                                        break;
                                    }
                                }
                                break;
                            }
                        }
                    }
                    if (isSupportCountry && isSupportLang) {
                        var pageUrl = basicUrl + productLine + "/" + productRelease
                                + "/" + productLang + "?redirected2=1&d="
                                + daysLeft + "&country=" + country;
                        $('#try_page').attr("src", pageUrl);
    
                        // Change current tab into Try Tab
                        ntp.page.tabs.addVisibleTab("tab_try", true);
                        isLoaded = true;
                        // Move hidden try tab content to target place.
                        var $preloaditm = $('#preload_try');
                        if ($preloaditm !== null) {
                            $('#tab_try .placeholder').remove();
                            $('#tab_try .content').empty().append(
                                    $preloaditm.children());
                            $preloaditm.remove();
                        }
                    }
                }
            }
            if(!isLoaded)
                $('#tab_try .placeholder').removeClass('loading');
        }
    };
})();

/**
 * Updates of learn tab content
 */
ntp.content.learnTab = (function() {

    var prevTipImage = 'images/prev_tip.png';
    var nextTipImage = 'images/next_tip.png';
    var hilightedContents = {};
    var hasFeaturedVideo = false;
    var hasGetStartedVideo = false;
    var hasResource = false;
    var hasTip = false;
    var notificationNum = 0;
    var $footerBadge = null;
    var $tipsData = null;
    var hilight = (function () {
        return {
            createElement: function (linkurl, uploadTime) {
                return $('<span>').addClass('newcontent').addClass('hidden').data({
                    url: linkurl,
                    upload_time: new Date(uploadTime)
                });
            }
        };
    })();
    var loadVideoList = function ($list, videos) {
        $list.empty();

        $.each(videos, function (i, video) {
            var $preview = $('<div>').addClass('video_preview');
            $preview.append($('<img>').addClass('thumb').attr({
                src : video.thumb,
                alt : 'thumbnail'
            })).append($('<span>').addClass('overlay'));

            var $title = $('<div>').addClass('title').html(video.title);
            var $info = $('<div>').append($title, $('<div>').addClass('desc').html(video.description).append($('<div>').addClass('duration').html(video.duration)), $('<div>').css('clear', 'both'));

            var $item = $('<li>').append($preview, $info).data({
                url: video.video,
                title: video.title,
                upload_time: video.upload_time
            });
            $list.append($item);

            if (typeof video.video !== 'undefined' && typeof video.upload_time !== 'undefined') {
                var uploadTimeFromServer = new Date(video.upload_time);

                if (uploadTimeFromServer > ntp.video.releasetime) {
                    $preview.append(hilightedContents[video.video] = hilight.createElement(video.video, video.upload_time));
                }
            }

            $item.click(ntp.utils.makeCallbackWithArgs(ntp.video, 'showPlayer', $item));
        });
    };

    var urlIsHilightedContent = function (url) {
        if (typeof hilightedContents[url] !== 'undefined' && !hilightedContents[url].hasClass('hidden')) {
            return true;
        } else {
            return false;
        }
    };

    var updateSectionVideos = function (data) {
        if (typeof data.retValue !== 'undefined')
            data = data.retValue; // hoist retValue if present
        hasFeaturedVideo = (typeof data.featuredVideoList !== 'undefined');
        hasGetStartedVideo = (typeof data.videoListSmall !== 'undefined');
        
        //Getting started videos
        if (typeof data.videoListSmall === 'object' && data.videoListSmall.video instanceof Array) {
            if (typeof data.videoListSmall.title === 'string') {
                $('#getting_started h1').text(data.videoListSmall.title);
            }

            loadVideoList($('#getting_started ol'), data.videoListSmall.video);
        } else {
            var $gettingStarted = $("#getting_started");
            $gettingStarted.next().remove();
            $gettingStarted.remove();
        }
        //feature videos
        if (typeof data.featuredVideoList === 'object' && data.featuredVideoList.video instanceof Array) {
            if (typeof data.featuredVideoList.title === 'string') {
                $('#feature_videos h1').text(data.featuredVideoList.title);
            }

            loadVideoList($('#feature_videos ol'), data.featuredVideoList.video);
        } else {
            var $featureVideos = $('#feature_videos');
            $featureVideos.remove();
        }
        //If the Getting Started and Feature Videos are not there remove section
        if ($('#feature_videos').length === 0 && $('#getting_started').length === 0) {
            var $sectionVidoes = $('#section_videos');
            $sectionVidoes.next().remove();
            $sectionVidoes.remove();
        }
        //update video column height.
        ntp.page.layout.updateVideoSectionHeight();
    };

    var updateLearnTipsSection = function (data) {
        if (typeof data.retValue !== 'undefined')
            data = data.retValue; // hoist retValue if present
        if (typeof data.tipsData !== 'undefined') {
            $tipsData = data.tipsData;
            $tipsData.whichTip = "next";
            updateTip();
        }
    };

    function updateTip() {
        var RecentlyUpdatedUrls = [];
        // Read current tipID and date
        RecentlyUpdatedUrls.push("tipID");
        RecentlyUpdatedUrls.push("tipExpireDate");

        ntp.acad.getLearnContentStateListAsJSON(RecentlyUpdatedUrls).done(ntp.utils.makeCallback(ntp.content.learnTab, 'LoadCurrentTip'));
    };

    function mouseRolloverImageUpdate(currentImage) {
        var str = currentImage.src;
        if (str.search("images/mouseover_") == -1) {
            str = str.replace("images/", "images/mouseover_");
        }
        else {
            str = str.replace("images/mouseover_", "images/");
        }
        currentImage.src = str;
    };

    function getTipToDisplay(currentTipData, tips, whichTip) {
        var $getCurrent = false;
        var $iter = 1;
        var $index = 0;

        while ($index < tips.length) {
            if (tips[$index].disabled == "true") {
                $index++;
            } else {
                break;
            }
        }
        if (whichTip == "forcePrev") {
            $index = tips.length - 1;
            $iter = -1;
        }
        else {
            if (whichTip == "next") {
                var $currentDate = new Date();
                var $tipExpireDate = new Date(currentTipData.tipExpireDate);

                if ($currentDate < $tipExpireDate) {
                    $getCurrent = true;
                }
            }
        }

        var i = 0;
        var $tiptodispaly = tips[$index];

        while (i < tips.length) {
            if (tips[$index].disabled == "true") {
                $index = ($index + $iter + tips.length)%tips.length;
                i++;
                continue;
            }
            if ($getCurrent == true) {
                if (tips[$index].id == currentTipData.tipID) {
                    $tiptodispaly = tips[$index];
                    break;
                }
            }
            else {
                if ($iter > 0 && tips[$index].id > currentTipData.tipID) {
                    $tiptodispaly = tips[$index];
                    break;
                }
                else if ($iter < 0 && tips[$index].id < currentTipData.tipID) {
                    $tiptodispaly = tips[$index];
                    break;
                }
            }
            $index = ($index + $iter + tips.length)%tips.length;
            i++;
        }
        return $tiptodispaly;
    };

    function parseTipContent(tipContent) {
        var $tipContentNode = $('<p id="tipcontent" >');

        for (var i = 0; i < tipContent.length; i++) {
            if (tipContent[i].text !== 'undefined') {
                $tipContentNode.append(tipContent[i].text);
            }
            if (typeof tipContent[i].icon !== 'undefined' && tipContent[i].icon !== null) {
                var icon = new Image();
                icon.src = tipContent[i].icon;

                $tipContentNode.append(icon);
            }
            if (typeof tipContent[i].image !== 'undefined' && tipContent[i].image !== null) {
                // We always want image in a new para
                var $tipImageNode = $('<p>');
                var icon = new Image();
                icon.src = tipContent[i].image;
                $tipImageNode.append(icon);

                $tipContentNode.append($tipImageNode);
            }
        }

        return $tipContentNode;
    };

    var updateOnlineResource = function (data) {
        if (typeof data.retValue !== 'undefined')
            data = data.retValue; // hoist retValue if present
        if (data.onlineResources) {
            hasResource = true;
            var $onlineResources = $('#online_resources_box');
            if (data.onlineResources.title) {
                $('#section_resources h1.resources').text(data.onlineResources.title);
            }
            if (data.onlineResources.description) {
                $onlineResources.append($('<p>').text(data.onlineResources.description));
            }
            if (data.onlineResources.links instanceof Array) {
                var $list = $('<ol>').addClass('flex');
                $onlineResources.append($list);

                $.each(data.onlineResources.links, function (i, link) {

                    var $listItem = $('<li>').addClass('button').append($('<img>').attr({
                        src: link.banner,
                        alt: link.caption
                    })).append($('<p>').text(link.caption));

                    //Append the hilight span if its a new link
                    if ((typeof link.url !== 'undefined' || typeof link.helpTopicId !== 'undefined') && typeof link.upload_time !== 'undefined') {

                        var uploadTimeFromServer = new Date(link.upload_time);
                        if (uploadTimeFromServer > ntp.video.releasetime) {
                            {
                                if (typeof link.url !== 'undefined')
                                    $listItem.append(hilightedContents[link.url] = hilight.createElement(link.url, link.upload_time));
                                else
                                    $listItem.append(hilightedContents[link.helpTopicId] = hilight.createElement(link.helpTopicId, link.upload_time));
                            }
                        }
                    }

                    $list.append($listItem);

                    if (link.url) {
                        if (link.external === true) {
                            $listItem.click(function () {
                                ntp.utils.openExternalUrlWithBrowser(link.url);
                                var $lightBoxPanel = $('#lightbox_panel');
                                $lightBoxPanel.addClass('leave_autodesk');

                                if (urlIsHilightedContent(link.url) === true) {
                                    ntp.acad.updateLearnContentState(link.url, link.upload_time);
                                }
                            });
                        } else {
                            $listItem.click(function () {
                                ntp.acad.openUrlWithBrowser(link.url);

                                if (urlIsHilightedContent(link.url) === true) {
                                    ntp.acad.updateLearnContentState(link.url, link.upload_time);
                                }
                            });
                        }
                    } else if (typeof link.helpTopicId === 'string' && link.helpTopicId !== "") {
                        $listItem.click(function (e) {
                            ntp.acad.openUrlWithHelpBrowser(link.helpTopicId);
                            e.preventDefault();
                            if (urlIsHilightedContent(link.helpTopicId) === true) {
                                ntp.acad.updateLearnContentState(link.helpTopicId, link.upload_time);
                            }
                        });
                    }
                });
            }

            ntp.page.layout.updateOnlineResourceHeight();
        } else {
            var $sectionResources = $('#section_resourceslinks');
            $sectionResources.remove();
        }
    };

    return {
        // ntp.content.learnTab
        urlIsHilightedContent: urlIsHilightedContent,

        hilightNewLearnConents: function (registryRecords) {
            if (typeof registryRecords.retValue !== 'undefined')
                registryRecords = registryRecords.retValue; // hoist retValue if present
            for (var url in hilightedContents) {
                if (hilightedContents.hasOwnProperty(url) && typeof hilightedContents[url] !== 'undefined') {
                    if (typeof registryRecords[url] === 'undefined' ||
                        hilightedContents[url].data('upload_time') > new Date(registryRecords[url])) {
                            hilightedContents[url].removeClass('hidden');
                            notificationNum++;
                        }
                }
            }

            //Update badge showing number.
            $footerBadge.html(notificationNum.toString());
            if (notificationNum > 0) {
                $footerBadge.removeClass('hidden');
            }
        },

        handleNextTip: function () {
            $tipsData.whichTip = "forceNext";
            updateTip();
        },
        mouseRolloverImageUpdate: function (obj) {
            mouseRolloverImageUpdate(obj);
        },
        handlePrevTip: function () {
            $tipsData.whichTip = "forcePrev"
            updateTip();
        },
        
        changeMouseOverImage: function() {
            this.src = "images/mouseover_next_tip.png";
        },

        LoadCurrentTip: function (RegisteredInfo) {
            var $currentTipData = $.parseJSON(RegisteredInfo);
            if (typeof $currentTipData.retValue !== 'undefined')
                $currentTipData = $currentTipData.retValue; // hoist retValue if present

            if ($tipsData && typeof $tipsData.learnTips !== 'undefined') {
                hasTip = true;
                var $tipContainer = $('#tip_container');
                var $tipResources = $('#tip_resource_box');
                var $tipDiv = $('<div id="tipdiv" style="position:relative;padding-right:15px" >');
                var $tipHeader = $('#tip_header');

                // Add images only when whole page is reloaded, not with next/previous tip
                if ($tipsData.whichTip == "next") {
                    $tipHeader.append($('<img id="nextImage" class="tip_header" >').attr({
                        'src' : nextTipImage,
                        'onclick' : 'ntp.content.learnTab.handleNextTip()',
                        'onMouseOver': 'ntp.content.learnTab.mouseRolloverImageUpdate(this)',
                        'onMouseOut': 'ntp.content.learnTab.mouseRolloverImageUpdate(this)',
                        }));

                    $tipHeader.append($('<img id="prevImage" class="tip_header" >').attr({
                        'src' : prevTipImage,
                        'onclick' : 'ntp.content.learnTab.handlePrevTip()',
                        'onMouseOver': 'ntp.content.learnTab.mouseRolloverImageUpdate(this)',
                        'onMouseOut': 'ntp.content.learnTab.mouseRolloverImageUpdate(this)',
                        }));
                    $.when(ntp.deferred.strings).done(function() {
                        $('#nextImage').prop('title', ntp.utils.localize('learn_next_tip'));
                        $('#prevImage').prop('title', ntp.utils.localize('learn_prev_tip'));
                    });

                }

                if ($tipsData.title) {
                    $('#section_resources h1.tip').text($tipsData.title);
                }

                var $tipToDisplay = getTipToDisplay($currentTipData, $tipsData.learnTips, $tipsData.whichTip);

                if ($tipToDisplay.content) {
                    var $tipContentNode = parseTipContent($tipToDisplay.content);

                    $tipDiv.append($tipContentNode);

                    if (typeof $tipToDisplay.caption !== 'undefined') {
                        $tipDiv.append($('<a href="fakeurl" tabindex="-1">').text($tipToDisplay.caption).on("click", function (e) {

                            if (typeof $tipToDisplay.helpTopicId !== 'undefined' && $tipToDisplay.helpTopicId !== "")
                                ntp.acad.openUrlWithHelpBrowser($tipToDisplay.helpTopicId);
                            else if (typeof $tipToDisplay.url !== 'undefined' && $tipToDisplay.url !== "")
                                ntp.acad.openUrlWithBrowser($tipToDisplay.url);

                            e.preventDefault();
                        }));
                    }
                    $tipResources.empty();
                    $tipResources.append($tipDiv);

                    var $todayDate = new Date();
                    $todayDate.setHours(23);
                    $todayDate.setMinutes(59);
                    $todayDate.setSeconds(59);

                    $tipResources.data({
                        upload_time: new Date(),
                        tip_ID: $tipToDisplay.id,
                        tip_Expire_Date: $todayDate,
                    });

                    //Append the hilight span if the tip is never visited
                    if (typeof $tipToDisplay.content !== 'undefined') {

                        if ($currentTipData.tipID != $tipToDisplay.id) {
                            if ( typeof hilightedContents['tip'] == 'undefined') {
                                $tipContainer.append(hilightedContents['tip'] = hilight.createElement('tip', new Date()));
                            }
                            // Update the tip data as user see next or previous tip
                            if ($tipsData.whichTip !== "next") {
                                ntp.acad.updateLearnContentState('tip', new Date());
                                ntp.acad.updateLearnContentState('tipID', $tipToDisplay.id);
                                ntp.acad.updateLearnContentState('tipExpireDate', $todayDate);
                            }
                        }
                    }
                }
            }
            else {
                var $tipSection = $('#Section_tip');
                if (typeof $tipSection != 'undefined' && $tipSection != null)
                    $('#Section_tip').remove();
            }

        },

        hasFeaturedVideos: function() {
            return hasFeaturedVideo;
        },
        
        hasGetStartedVideos: function() {
            return hasGetStartedVideo;
        },
        
        hasOnlineResource: function() {
            return hasResource;
        },
        
        hasTips: function() {
            return hasTip;
        },

        updateLearnTipsData: function (data) {
            updateLearnTipsSection(data);
        },

        unhilightViewedLearnConents: function (registryRecords) {

            if (typeof registryRecords.retValue !== 'undefined')
                registryRecords = registryRecords.retValue; // hoist retValue if present

            if (typeof registryRecords['RecentViewed'] !== 'undefined' &&
                urlIsHilightedContent(registryRecords['RecentViewed']) === true) {

                if (registryRecords['RecentViewed'] === 'tip' && ntp.page.tabs.isTipContentsVisited() === false) {
                    hilightedContents[registryRecords['RecentViewed']].addClass('hidden');
                    notificationNum--;
                } else if (registryRecords['RecentViewed'] !== 'tip') {
                    hilightedContents[registryRecords['RecentViewed']].addClass('hidden');
                    notificationNum--;
                }
            }

            if (typeof registryRecords['tip'] !== 'undefined' && urlIsHilightedContent('tip') === true) {
                hilightedContents['tip'].addClass('hidden');
                notificationNum--;
            }
            //Update badge showing number.
            if ($footerBadge !== null) {
                $footerBadge.html(notificationNum.toString());
                if (notificationNum === 0) {
                    $footerBadge.addClass('hidden');
                }
            }
        },

        unhilightRecentViewed: function (RegisteredInfo) {
            this.unhilightViewedLearnConents($.parseJSON(RegisteredInfo));
        },

        hilightRecentUpdates: function (RegisteredInfo) {
            this.hilightNewLearnConents($.parseJSON(RegisteredInfo));
        },

        load: function(data) {

            if (typeof data.retValue !== 'undefined')
                data = data.retValue; // hoist retValue if present

            $footerBadge = $('#footer_learn_badge');

            //load A360 widget based on url.
            if (typeof data.url_connect_widget === 'string' && data.url_connect_widget !== "") {
                //Set url and try to load A360 widget
                ntp.widget.connect.setWidgetURL(data.url_connect_widget);
            }
            ntp.widget.connect.beginRefresh();

            if (typeof data.release_time === 'string') {
                ntp.video.releasetime = new Date(data.release_time);
            }
            if ( typeof data.videoWidth === 'number') {
                ntp.video.videoWidth = data.videoWidth;
            }
            if ( typeof data.videoHeight === 'number') {
                ntp.video.videoHeight = data.videoHeight;
            }

            if ( typeof data.videoListLarge === 'object' && data.videoListLarge.video instanceof Array) {
                if ( typeof data.videoListLarge.title === 'string') {
                    $('#section_whats_new h1').text(data.videoListLarge.title);
                }
                loadVideoList($('#section_whats_new ol'), data.videoListLarge.video);
            } else {
                var $sectionWhatsNew = $('#section_whats_new');
                $sectionWhatsNew.next().remove();
                $sectionWhatsNew.remove();
            }

            //update Section videos
            updateSectionVideos(data);

            //update online resource
            updateOnlineResource(data);

            //Hilight the Recently added learn contents.
            var RecentlyUpdatedUrls = [];
            for (var url in hilightedContents) {
                if (hilightedContents.hasOwnProperty(url))
                    RecentlyUpdatedUrls.push(url);
            }
            if (RecentlyUpdatedUrls.length > 0)
                ntp.acad.getLearnContentStateListAsJSON(RecentlyUpdatedUrls).done(ntp.utils.makeCallback(this, 'hilightRecentUpdates'));

        }
    };
})();

/**
 * Triggers update of content on events
 */
(function() {
    ntp.deferred.customization.done(function() {
        ntp.deferred.strings.done(function(data) {
            ntp.content.applyLocalizedStrings(data);
            ntp.deferred.localization.resolve();
        });
    });

    $.when(ntp.deferred.localization, ntp.deferred.customization).done(function() {
        
        $.when.apply(null, ntp.asyncLoadings).always(function() {
            ntp.widget.notifications.adjustContainerHeight();
            $('#preload_mask').remove();
        });

        // Load the content of learn tab
        ntp.deferred.learnTab.done(function(data) {

            ntp.widget.connect.setIsOnline(true);
            ntp.content.learnTab.load(data);

            // Move hidden learn tab content to target place.
            var $preloadLearn = $('#preload_learn');
            $('#tab_learn .placeholder').remove();
            $('#tab_learn .content').empty().append($preloadLearn.children());
            $preloadLearn.remove();

            ntp.page.tabs.addVisibleTab("tab_learn", false);
            ntp.page.layout.update(); 
        }).fail(function() {
            // Show offine help download notification box when load learn page failure.
            ntp.widget.notifications.beginGetOfflineHelpStatus();
            ntp.widget.connect.setIsOnline(false);
            ntp.widget.connect.beginRefresh();
        });
    });
})();

// SIG // Begin signature block
// SIG // MIIZ7QYJKoZIhvcNAQcCoIIZ3jCCGdoCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // A9bD2TQeVSXQsTb8WiBJLhTdPvt6gUz04JlvnFA5Qwug
// SIG // ggpjMIIFAjCCA+qgAwIBAgIQZLyxx87k2lhp1Y8eIvvp
// SIG // 9DANBgkqhkiG9w0BAQsFADB/MQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAd
// SIG // BgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIENsYXNzIDMgU0hBMjU2IENv
// SIG // ZGUgU2lnbmluZyBDQTAeFw0xNTA5MDMwMDAwMDBaFw0x
// SIG // NjA5MDIyMzU5NTlaMIGIMQswCQYDVQQGEwJVUzETMBEG
// SIG // A1UECAwKQ2FsaWZvcm5pYTETMBEGA1UEBwwKU2FuIFJh
// SIG // ZmFlbDEWMBQGA1UECgwNQXV0b2Rlc2ssIEluYzEfMB0G
// SIG // A1UECwwWRGVzaWduIFNvbHV0aW9ucyBHcm91cDEWMBQG
// SIG // A1UEAwwNQXV0b2Rlc2ssIEluYzCCASIwDQYJKoZIhvcN
// SIG // AQEBBQADggEPADCCAQoCggEBAOqZ9OjPzARqd9dP4fq2
// SIG // qXdpTJolFYJ8Wxg8WcZVciX3l+dljew4R9C8WR/0tW17
// SIG // lLANaSORF4IYmWTgdpFg5PGR3s+R4A461hpRIG9QthGU
// SIG // q8Bt7af5VbCjjKtYBNq/x3ukqVsw/1/qljGVplDOyr97
// SIG // 6ktnCm0/wL0N+ubk5WAIgv+I9E0i6+GX1hRm+eRliYKe
// SIG // KF0/gBLyDh3ut+N3HNPrnfjfec7q2Czd82CeRBCToR1E
// SIG // 7Cp6yBBdGUfb3JE0PnE1+6n0qJnsvs2bsCIzqVo3A0iM
// SIG // HBsbioxa5DYyXuEfNCktosUlFXfegd514ZJns6YDr4Pl
// SIG // ahC0+lK3hgJy5vkCAwEAAaOCAW4wggFqMAkGA1UdEwQC
// SIG // MAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsG
// SIG // AQUFBwMDMGYGA1UdIARfMF0wWwYLYIZIAYb4RQEHFwMw
// SIG // TDAjBggrBgEFBQcCARYXaHR0cHM6Ly9kLnN5bWNiLmNv
// SIG // bS9jcHMwJQYIKwYBBQUHAgIwGRoXaHR0cHM6Ly9kLnN5
// SIG // bWNiLmNvbS9ycGEwHwYDVR0jBBgwFoAUljtT8Hkzl699
// SIG // g+8uK8zKt4YecmYwKwYDVR0fBCQwIjAgoB6gHIYaaHR0
// SIG // cDovL3N2LnN5bWNiLmNvbS9zdi5jcmwwVwYIKwYBBQUH
// SIG // AQEESzBJMB8GCCsGAQUFBzABhhNodHRwOi8vc3Yuc3lt
// SIG // Y2QuY29tMCYGCCsGAQUFBzAChhpodHRwOi8vc3Yuc3lt
// SIG // Y2IuY29tL3N2LmNydDARBglghkgBhvhCAQEEBAMCBBAw
// SIG // FgYKKwYBBAGCNwIBGwQIMAYBAQABAf8wDQYJKoZIhvcN
// SIG // AQELBQADggEBAB6BYdY8nzLWS3nsk/xM5CWdizR4wyDn
// SIG // 8wfGVbcuEq/88byNnY0ODxisa7AELvLe6b48DorFFP2n
// SIG // Hw0qOeIxfg2w+1DzWzYQhMfLi4V/Pp1OmCYvYEsTb/oU
// SIG // +YbiSgSFjrN5Pi2LN5Oxw5Ey7WAK2vhWr4EL/7QDHoso
// SIG // 4a3lS3WklPz2K/Nlhk4i8S230BlGCHsZGDY7PtfowWdz
// SIG // cq50xCEIScERSRtLd+YL6SWXk+6gX9HVcFxtvLQ4N9Df
// SIG // F/BKk13pYgyvZPkedIKA4yYCy4/VjouNoKhgM/aaGLAy
// SIG // Dv3ujRdXLCcosR4MbD8X1v9z6WkgG5YZZicWPPsJN7ty
// SIG // B1wwggVZMIIEQaADAgECAhA9eNf5dklgsmF99PAeyoYq
// SIG // MA0GCSqGSIb3DQEBCwUAMIHKMQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsT
// SIG // FlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsT
// SIG // MShjKSAyMDA2IFZlcmlTaWduLCBJbmMuIC0gRm9yIGF1
// SIG // dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlT
// SIG // aWduIENsYXNzIDMgUHVibGljIFByaW1hcnkgQ2VydGlm
// SIG // aWNhdGlvbiBBdXRob3JpdHkgLSBHNTAeFw0xMzEyMTAw
// SIG // MDAwMDBaFw0yMzEyMDkyMzU5NTlaMH8xCzAJBgNVBAYT
// SIG // AlVTMR0wGwYDVQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlv
// SIG // bjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29y
// SIG // azEwMC4GA1UEAxMnU3ltYW50ZWMgQ2xhc3MgMyBTSEEy
// SIG // NTYgQ29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAQ8AMIIBCgKCAQEAl4MeABavLLHSCMTXaJNR
// SIG // YB5x9uJHtNtYTSNiarS/WhtR96MNGHdou9g2qy8hUNqe
// SIG // 8+dfJ04LwpfICXCTqdpcDU6kDZGgtOwUzpFyVC7Oo9tE
// SIG // 6VIbP0E8ykrkqsDoOatTzCHQzM9/m+bCzFhqghXuPTbP
// SIG // HMWXBySO8Xu+MS09bty1mUKfS2GVXxxw7hd924vlYYl4
// SIG // x2gbrxF4GpiuxFVHU9mzMtahDkZAxZeSitFTp5lbhTVX
// SIG // 0+qTYmEgCscwdyQRTWKDtrp7aIIx7mXK3/nVjbI13Iwr
// SIG // b2pyXGCEnPIMlF7AVlIASMzT+KV93i/XE+Q4qITVRrgT
// SIG // hsIbnepaON2b2wIDAQABo4IBgzCCAX8wLwYIKwYBBQUH
// SIG // AQEEIzAhMB8GCCsGAQUFBzABhhNodHRwOi8vczIuc3lt
// SIG // Y2IuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwbAYDVR0g
// SIG // BGUwYzBhBgtghkgBhvhFAQcXAzBSMCYGCCsGAQUFBwIB
// SIG // FhpodHRwOi8vd3d3LnN5bWF1dGguY29tL2NwczAoBggr
// SIG // BgEFBQcCAjAcGhpodHRwOi8vd3d3LnN5bWF1dGguY29t
// SIG // L3JwYTAwBgNVHR8EKTAnMCWgI6Ahhh9odHRwOi8vczEu
// SIG // c3ltY2IuY29tL3BjYTMtZzUuY3JsMB0GA1UdJQQWMBQG
// SIG // CCsGAQUFBwMCBggrBgEFBQcDAzAOBgNVHQ8BAf8EBAMC
// SIG // AQYwKQYDVR0RBCIwIKQeMBwxGjAYBgNVBAMTEVN5bWFu
// SIG // dGVjUEtJLTEtNTY3MB0GA1UdDgQWBBSWO1PweTOXr32D
// SIG // 7y4rzMq3hh5yZjAfBgNVHSMEGDAWgBR/02Wnwt3su/Aw
// SIG // CfNDOfoCrzMxMzANBgkqhkiG9w0BAQsFAAOCAQEAE4Ua
// SIG // HmmpN/egvaSvfh1hU/6djF4MpnUeeBcj3f3sGgNVOftx
// SIG // lcdlWqeOMNJEWmHbcG/aIQXCLnO6SfHRk/5dyc1eA+CJ
// SIG // nj90Htf3OIup1s+7NS8zWKiSVtHITTuC5nmEFvwosLFH
// SIG // 8x2iPu6H2aZ/pFalP62ELinefLyoqqM9BAHqupOiDlAi
// SIG // KRdMh+Q6EV/WpCWJmwVrL7TJAUwnewusGQUioGAVP9rJ
// SIG // +01Mj/tyZ3f9J5THujUOiEn+jf0or0oSvQ2zlwXeRAwV
// SIG // +jYrA9zBUAHxoRFdFOXivSdLVL4rhF4PpsN0BQrvl8OJ
// SIG // IrEfd/O9zUPU8UypP7WLhK9k8tAUITGCDuIwgg7eAgEB
// SIG // MIGTMH8xCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1h
// SIG // bnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50
// SIG // ZWMgVHJ1c3QgTmV0d29yazEwMC4GA1UEAxMnU3ltYW50
// SIG // ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
// SIG // AhBkvLHHzuTaWGnVjx4i++n0MA0GCWCGSAFlAwQCAQUA
// SIG // oHwwEAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkD
// SIG // MQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwG
// SIG // CisGAQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIKM4E2Ga
// SIG // vLQ2sRA/0EQQBIRjjApV09YMjNvHvYdncd55MA0GCSqG
// SIG // SIb3DQEBAQUABIIBALPcxtbiNWq5WsxwDbJVogH8ZAHl
// SIG // rTYbOD70/wQprfM5C1WO34ZGnemXZ+S9tllTcGgRzYFB
// SIG // NpIikSPkJDEyyhABuxEkS5QgCrv1RCPb59yW8nlCNsp/
// SIG // 6pKyfwulVsVRBNG20aFOt9UdMm24nqS2xh8YAQg+zVpV
// SIG // 2ykDKsPguy5jjjMeWZNjyT2TZhTsKocCDqW81s2DwcDi
// SIG // U1x0YqF9goEqf8r0WuNUxn2ulSU2oer6EXkfcI4n7Mvx
// SIG // 4yCw/hXMequ6uBFV0CKy8I7+SRP8MsC5SWUhhoTbk5ZT
// SIG // iZ4j9fQWQ4SL1Sp1T1MXL7ik4MLekCtg6KUPHxkyKZS8
// SIG // tFF5WNyhggyhMIIMnQYKKwYBBAGCNwMDATGCDI0wggyJ
// SIG // BgkqhkiG9w0BBwKgggx6MIIMdgIBAzEPMA0GCWCGSAFl
// SIG // AwQCAQUAMIHdBgsqhkiG9w0BCRABBKCBzQSByjCBxwIB
// SIG // AQYJKwYBBAGgMgIDMDEwDQYJYIZIAWUDBAIBBQAEIFcU
// SIG // TdkU8i5xcu5mEa8744fG5Vl1vDpbHHfiPfLvBLeyAhQG
// SIG // rx/P8konK70V/P0SM7EH4szmOBgPMjAxNjAyMDcwNTA5
// SIG // MTJaoF2kWzBZMQswCQYDVQQGEwJTRzEfMB0GA1UEChMW
// SIG // R01PIEdsb2JhbFNpZ24gUHRlIEx0ZDEpMCcGA1UEAxMg
// SIG // R2xvYmFsU2lnbiBUU0EgZm9yIEFkdmFuY2VkIC0gRzKg
// SIG // ggjGMIIEqTCCA5GgAwIBAgISESEWwAmY3MaPon0lw4Y2
// SIG // qIO7MA0GCSqGSIb3DQEBCwUAMFsxCzAJBgNVBAYTAkJF
// SIG // MRkwFwYDVQQKExBHbG9iYWxTaWduIG52LXNhMTEwLwYD
// SIG // VQQDEyhHbG9iYWxTaWduIFRpbWVzdGFtcGluZyBDQSAt
// SIG // IFNIQTI1NiAtIEcyMB4XDTE1MDIwMzAwMDAwMFoXDTI2
// SIG // MDMwMzAwMDAwMFowWTELMAkGA1UEBhMCU0cxHzAdBgNV
// SIG // BAoTFkdNTyBHbG9iYWxTaWduIFB0ZSBMdGQxKTAnBgNV
// SIG // BAMTIEdsb2JhbFNpZ24gVFNBIGZvciBBZHZhbmNlZCAt
// SIG // IEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
// SIG // AQEAt8eSiijY85HLUA1d6ylEwYJZpcpkzr2DtVHllMxu
// SIG // gJoXbNz/YuY2Q14Bwgxkjcp3nvZdd0W5Xsgk60E3EWY3
// SIG // rMjNdJvMs+9M4n8bznO+yZadNR5891T3bOygEtaumZ1j
// SIG // xHhfWakuIvXDJ9iyW0VjJ5D/jLE9qbTzDsDxIGUGiZ0D
// SIG // HKOwUkGFNOu8y85U9hL+swGJSqb6VMUf+9McwOO/l+M/
// SIG // 0Bv5QMcb1esmfEMwx3DyeBGqhU6lDg0ASjoRd6PKIwGA
// SIG // nsiTVl1GzIrY0qoKhIWyiVvVMs5BexhOVMqr0VJeEtMk
// SIG // nlbzDI/dvZKOedVBicOjoOWR/MdnnYczznEycwIDAQAB
// SIG // o4IBZzCCAWMwDgYDVR0PAQH/BAQDAgeAMEwGA1UdIARF
// SIG // MEMwQQYJKwYBBAGgMgEeMDQwMgYIKwYBBQUHAgEWJmh0
// SIG // dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRv
// SIG // cnkvMAkGA1UdEwQCMAAwFgYDVR0lAQH/BAwwCgYIKwYB
// SIG // BQUHAwgwRgYDVR0fBD8wPTA7oDmgN4Y1aHR0cDovL2Ny
// SIG // bC5nbG9iYWxzaWduLmNvbS9ncy9nc3RpbWVzdGFtcGlu
// SIG // Z3NoYTJnMi5jcmwwWAYIKwYBBQUHAQEETDBKMEgGCCsG
// SIG // AQUFBzAChjxodHRwOi8vc2VjdXJlLmdsb2JhbHNpZ24u
// SIG // Y29tL2NhY2VydC9nc3RpbWVzdGFtcGluZ3NoYTJnMi5j
// SIG // cnQwHQYDVR0OBBYEFC1ubtGN5QOA7udj6afZ2gs8VyI9
// SIG // MB8GA1UdIwQYMBaAFJIhp0qVXWSwm7Qe5gA3R+adQStM
// SIG // MA0GCSqGSIb3DQEBCwUAA4IBAQB/CgOhVXb+qvoU0RF6
// SIG // 4uIPOjL/e0bGBHGMXtDMeUfddQdtuki+P2DiyxEgwrar
// SIG // Q8e3otm4Wv7NtDqz8VJTDLSO/2LdiJuyGn8bUbdxh9pD
// SIG // SzdSzf4+BilwpCds59w8f3bjkMga6ZkSUO7qTCMayF+c
// SIG // 1SmEKuaBYgZ2gnajE1UOSKZR0fNMDTwIICiGaoO3nQyg
// SIG // XmA0BjGofXGPUfIE36Imk7nVKHejoLdCo4swJ1oJ9tyD
// SIG // mCHVfUGaBxkUWih2fa2goyQBTuEWyL9/R/M6BF5lPqJM
// SIG // //1vBs+suBsAZ/rva37X4gq/e8WnEqzXNPVXiD6Elq1r
// SIG // VC49Jw/iORrBxxhyMIIEFTCCAv2gAwIBAgILBAAAAAAB
// SIG // MYnGUAQwDQYJKoZIhvcNAQELBQAwTDEgMB4GA1UECxMX
// SIG // R2xvYmFsU2lnbiBSb290IENBIC0gUjMxEzARBgNVBAoT
// SIG // Ckdsb2JhbFNpZ24xEzARBgNVBAMTCkdsb2JhbFNpZ24w
// SIG // HhcNMTEwODAyMTAwMDAwWhcNMjkwMzI5MTAwMDAwWjBb
// SIG // MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2ln
// SIG // biBudi1zYTExMC8GA1UEAxMoR2xvYmFsU2lnbiBUaW1l
// SIG // c3RhbXBpbmcgQ0EgLSBTSEEyNTYgLSBHMjCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAKqbjsOrEVEl
// SIG // AbaWlOJP2MEI9kYj2UXFlZdbqxq/0mxXyTMGH6APxjx+
// SIG // U0h6v52Hnq/uw4xH4ULs4+OhSmwMF8SmwbnNW/EeRImO
// SIG // /gveIVgT7k3IxWcLHLKz8TR2kaLLB203xaBHJgIVpJCR
// SIG // qXme1+tXnSt8ItgU1/EHHngiNmt3ea+v+X+OTuG1CDH9
// SIG // 6u1LcWKMI/EDOY9EebZ2A1eerS8IRtzSjLz0jnTOyGhp
// SIG // UXYRiw9dJFsZVD0mzECNgicbWSB9WfaTgI74Kjj9a6BA
// SIG // ZR9XdsxbjgRPLKjbhFATT8bci7n43WlMiOucezAm/HpY
// SIG // u1m8FHKSgVe3dsnYgAqAbgkCAwEAAaOB6DCB5TAOBgNV
// SIG // HQ8BAf8EBAMCAQYwEgYDVR0TAQH/BAgwBgEB/wIBADAd
// SIG // BgNVHQ4EFgQUkiGnSpVdZLCbtB7mADdH5p1BK0wwRwYD
// SIG // VR0gBEAwPjA8BgRVHSAAMDQwMgYIKwYBBQUHAgEWJmh0
// SIG // dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRv
// SIG // cnkvMDYGA1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9jcmwu
// SIG // Z2xvYmFsc2lnbi5uZXQvcm9vdC1yMy5jcmwwHwYDVR0j
// SIG // BBgwFoAUj/BLf6guRSSuTVD6Y5qL3uLdG7wwDQYJKoZI
// SIG // hvcNAQELBQADggEBAARWgkp80M7JvzZm0b41npNsl+gG
// SIG // zjEYWflsQV+ALsBCJbgYx/zUsTfEaKDPKGoDdEtjl4V3
// SIG // YTvXL+P1vTOikn0RH56KbO8ssPRijTZz0RY28bxe7LSA
// SIG // mHj80nZ56OEhlOAfxKLhqmfbs5xz5UAizznO2+Z3lae7
// SIG // ssv2GYadn8jUmAWycW9Oda7xPWRqO15ORqYqXQiS8aPz
// SIG // HXS/Yg0jjFwqOJXSwNXNz4jaHyi1uoFpZCq1pqLVc6/c
// SIG // RtsErpHXbsWYutRHxFZ0gEd4WIy+7yv97Gy/0ZT3v1Dg
// SIG // e+CQ/SAYeBgiXQgujBygl/MdmX2jnZHTBkROBG56HCDj
// SIG // NvC2ULkxggK0MIICsAIBATBxMFsxCzAJBgNVBAYTAkJF
// SIG // MRkwFwYDVQQKExBHbG9iYWxTaWduIG52LXNhMTEwLwYD
// SIG // VQQDEyhHbG9iYWxTaWduIFRpbWVzdGFtcGluZyBDQSAt
// SIG // IFNIQTI1NiAtIEcyAhIRIRbACZjcxo+ifSXDhjaog7sw
// SIG // DQYJYIZIAWUDBAIBBQCgggEUMBoGCSqGSIb3DQEJAzEN
// SIG // BgsqhkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMTYw
// SIG // MjA3MDUwOTEyWjAvBgkqhkiG9w0BCQQxIgQgYKsBYqsh
// SIG // tEnGBkGlY22B2R+izHICbYXYGnEDRKFN8fYwgaYGCyqG
// SIG // SIb3DQEJEAIMMYGWMIGTMIGQMIGNBBRXqt6jTjqEJxGX
// SIG // sll4jXMMauIuyTB1MF+kXTBbMQswCQYDVQQGEwJCRTEZ
// SIG // MBcGA1UEChMQR2xvYmFsU2lnbiBudi1zYTExMC8GA1UE
// SIG // AxMoR2xvYmFsU2lnbiBUaW1lc3RhbXBpbmcgQ0EgLSBT
// SIG // SEEyNTYgLSBHMgISESEWwAmY3MaPon0lw4Y2qIO7MA0G
// SIG // CSqGSIb3DQEBAQUABIIBAJoIm20la9w2y/tKc+wk9W96
// SIG // FSOI6u0vq/hFONXTffpSUNcC1yvw8Z//zee+WjDfJNP3
// SIG // riCQYJ/fql7IPusM2M9eV7UfjpEApW+UhEBWtmZHTpv8
// SIG // TJPVk8VQ8Xs3je7Ll8Vq+l8jWyY+Ss9dzC3hlow5pJ/+
// SIG // Fdp0ZGplatX6tMbKsFRBO4/BN/ZYPB0TfG9yrRRtEi76
// SIG // TLk/Gr8QEQLdvbVjCnkHXru5ifgihUIkvNNHZmDYPHjp
// SIG // /pl3wQxcNnAyP2h8gSCJdc9cpf/HI20+zt4KbZy02wyj
// SIG // uq9lDEvVPz7er7OoHn/9F6KkPAfSv81OpuGGWtQSxiLE
// SIG // HSiJ+XT1ziM=
// SIG // End signature block
